<?php
$options = array(
	'colormag_footer_column_heading' => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Footer Column', 'colormag' ),
		'section'      => 'colormag_footer_column_section',
		'sub_controls' => apply_filters(
			'colormag_schema_markup_controls',
			array(
				'colormag_footer_general_subtitle' => array(
					'title'   => esc_html__( 'General', 'colormag' ),
					'type'    => 'customind-title',
					'section' => 'colormag_footer_column_section',
				),
				'colormag_main_footer_layout'      => array(
					'default' => 'layout-1',
					'type'    => 'customind-select',
					'title'   => esc_html__( 'Layout', 'colormag' ),
					'section' => 'colormag_single_post_section',
					'choices' => array(
						'layout-1' => esc_html__( 'Layout 1', 'colormag' ),
						'layout-2' => esc_html__( 'Layout 2', 'colormag' ),
						'layout-3' => esc_html__( 'Layout 3', 'colormag' ),
					),
				),
				'colormag_footer_style_divider'    => array(
					'type'    => 'customind-divider',
					'variant' => 'dashed',
					'section' => 'colormag_single_post_section',
				),
				'colormag_footer_style_subtitle'   => array(
					'title'   => esc_html__( 'Style', 'colormag' ),
					'type'    => 'customind-title',
					'section' => 'colormag_single_post_section',
				),
				'colormag_footer_background'       => array(
					'default'   => array(
						'background-color'      => '',
						'background-image'      => '',
						'background-repeat'     => 'repeat',
						'background-position'   => 'center center',
						'background-size'       => 'contain',
						'background-attachment' => 'scroll',
					),
					'type'      => 'customind-background',
					'title'     => esc_html__( 'Background', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_footer_column_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_footer_column_collapsible', false ),
	),
	'colormag_upper_footer_heading'  => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Upper Footer', 'colormag' ),
		'section'      => 'colormag_footer_column_section',
		'sub_controls' => apply_filters(
			'colormag_upper_footer_controls',
			array(
				'colormag_upper_footer_background' => array(
					'default'   => array(
						'background-color'      => '',
						'background-image'      => '',
						'background-repeat'     => 'repeat',
						'background-position'   => 'center center',
						'background-size'       => 'contain',
						'background-attachment' => 'scroll',
					),
					'type'      => 'customind-background',
					'title'     => esc_html__( 'Background', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_footer_column_section',
				),
				'colormag_upper_footer_color'      => array(
					'default'   => '#ffffff',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Color', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_footer_column_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_upper_footer_accordion_collapsible', false ),
	),
	'colormag_widget_title_title'    => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Widget Title', 'colormag' ),
		'section'      => 'colormag_footer_column_section',
		'sub_controls' => apply_filters(
			'colormag_widget_title_controls',
			array(
				'colormag_footer_widget_title_color'      => array(
					'default'   => '#ffffff',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Color', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_footer_column_section',
				),
				'colormag_footer_widget_title_typography' => array(
					'default'   => array(
						'font-family'    => 'inherit',
						'font-weight'    => '400',
						'font-size'      => array(
							'desktop' => array(
								'size' => '18',
								'unit' => 'px',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'line-height'    => array(
							'desktop' => array(
								'size' => '1.8',
								'unit' => '-',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'font-style'     => 'normal',
						'text-transform' => 'none',
					),
					'type'      => 'customind-typography',
					'transport' => 'postMessage',
					'title'     => esc_html__( 'Typography', 'colormag' ),
					'section'   => 'colormag_footer_column_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_widget_title_accordion_collapsible', false ),
	),
	'colormag_widget_content_title'  => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Widget Content', 'colormag' ),
		'section'      => 'colormag_footer_column_section',
		'sub_controls' => apply_filters(
			'colormag_widget_content_controls',
			array(
				'colormag_footer_widget_content_color' => array(
					'default'   => '#ffffff',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Color', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_footer_column_section',
				),
				'colormag_footer_widget_content_typography' => array(
					'default'   => array(
						'font-family'    => 'inherit',
						'font-weight'    => '400',
						'font-size'      => array(
							'desktop' => array(
								'size' => '14',
								'unit' => 'px',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'line-height'    => array(
							'desktop' => array(
								'size' => '1.8',
								'unit' => '-',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'font-style'     => 'normal',
						'text-transform' => 'none',
					),
					'type'      => 'customind-typography',
					'transport' => 'postMessage',
					'title'     => esc_html__( 'Typography', 'colormag' ),
					'section'   => 'colormag_footer_column_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_widget_content_accordion_collapsible', false ),
	),
	'colormag_widget_link_title'     => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Widget Link', 'colormag' ),
		'section'      => 'colormag_footer_column_section',
		'sub_controls' => apply_filters(
			'colormag_widget_link_controls',
			array(
				'colormag_footer_widget_link_color_group' => array(
					'type'         => 'customind-color-group',
					'title'        => esc_html__( 'Color', 'colormag' ),
					'section'      => 'colormag_footer_column_section',
					'sub_controls' => apply_filters(
						'colormag_footer_widget_link_color_controls',
						array(
							'colormag_footer_widget_content_link_text_color' => array(
								'default'   => '#ffffff',
								'type'      => 'customind-color',
								'title'     => esc_html__( 'Normal', 'colormag' ),
								'transport' => 'postMessage',
								'section'   => 'colormag_footer_column_section',
							),
							'colormag_footer_widget_content_link_text_hover_color' => array(
								'default'   => 'var(--cm-color-1)',
								'type'      => 'customind-color',
								'title'     => esc_html__( 'Hover', 'colormag' ),
								'transport' => 'postMessage',
								'section'   => 'colormag_footer_column_section',
							),
						)
					),
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_widget_link_accordion_collapsible', false ),
	),
);

colormag_customind()->add_controls( $options );
